<?php
// --- BACKEND: AJAX Apstrāde ---
if (isset($_GET['action'])) {
    header('Content-Type: application/json; charset=utf-8');
    error_reporting(E_ALL);
    ini_set('display_errors', 0); // Keep 0 for production
    ini_set('log_errors', 1);
    // ini_set('error_log', '/path/to/your/php-error.log');

    // --- Datubāzes un Konfigurācijas Definīcijas ---
    $dbHost = 'xxx';
    $dbName = 'xxx';
    $dbUser = 'xxx';
    $dbPass = 'xxx';

    $levelColorsPHP = ['A' => '#FFBF00', 'B' => '#FFBF00', 'C' => '#FFBF00', 'D' => '#FFBF00', 'E' => '#FFBF00', 'NULL' => '#AAAAAA']; // Gold for PPL icons
    $levelGreyColor = '#B0B0B0'; // Grey for PPL icons

    $establishmentTypes = ['Kafejnīca', 'Restorāns', 'Krogs', 'Frizētava'];
    $pplToIndex = ['E' => 0, 'D' => 1, 'C' => 2, 'B' => 3, 'A' => 4];
    $indexToPPL = ['E', 'D', 'C', 'B', 'A'];

    $typeToDbTable = [
        'Kafejnīca' => 'u260470642_cofe',
        'Restorāns' => 'u260470642_food',
        'Krogs'     => 'u260470642_bar',
        'Frizētava' => 'u260470642_frizieri'
    ];
    $dbTableToType = array_flip($typeToDbTable);

    // --- DATU KOPAS AR SCENĀRIJIEM ---
    $dataScenarios = [ /* ... NEMAINĪTS ... */ 'pessimistic' => [ 'visitorsPer1000' => [ 'Kafejnīca'=>[15,30,45,65,85],'Restorāns'=>[3,7,12,20,35],'Krogs'=>[10,20,30,40,50],'Frizētava'=>[5,7,10,13,16] ], 'averagePrice' => [ 'Kafejnīca'=>[2.50,3.50,4.50,5.50,6.50],'Restorāns'=>[8.00,11.00,15.00,19.00,24.00],'Krogs'=>[5.00,7.00,9.00,12.00,15.00],'Frizētava'=>[10.00,14.00,18.00,23.00,28.00] ], 'initialInvestment' => [ 'Kafejnīca'=>[10000,12000,15000,18000,22000],'Restorāns'=>[25000,30000,38000,45000,55000],'Krogs'=>[15000,18000,22000,27000,33000],'Frizētava'=>[8000,10000,13000,16000,20000] ] ], 'optimistic' => [ 'visitorsPer1000' => [ 'Kafejnīca'=>[25,50,80,110,140],'Restorāns'=>[5,15,30,55,90],'Krogs'=>[10,20,40,60,80],'Frizētava'=>[8,12,18,25,35] ], 'averagePrice' => [ 'Kafejnīca'=>[3.50,5.00,7.00,9.00,12.00],'Restorāns'=>[10.00,17.00,25.00,35.00,50.00],'Krogs'=>[7.00,10.00,15.00,22.00,30.00],'Frizētava'=>[15.00,22.00,30.00,45.00,60.00] ], 'initialInvestment' => [ 'Kafejnīca'=>[25000,35000,45000,60000,80000],'Restorāns'=>[60000,80000,110000,150000,200000],'Krogs'=>[40000,55000,70000,90000,120000],'Frizētava'=>[20000,30000,40000,55000,75000] ] ] ];
    // Bāzes kredīta atmaksa
    $baseDailyLoanRepaymentCLevel = [ /* ... NEMAINĪTS ... */ 'Kafejnīca' => round($dataScenarios['pessimistic']['initialInvestment']['Kafejnīca'][2] / (2*365), 2), 'Restorāns' => round($dataScenarios['pessimistic']['initialInvestment']['Restorāns'][2] / (2*365), 2), 'Krogs' => round($dataScenarios['pessimistic']['initialInvestment']['Krogs'][2] / (2*365), 2), 'Frizētava' => round($dataScenarios['pessimistic']['initialInvestment']['Frizētava'][2] / (2*365), 2) ];
    // Dinamisko izmaksu konstantes
    define('WORKING_HOURS_PER_DAY', 12); define('BASE_STAFF_PER_5_VISITORS', 2); define('EXTRA_STAFF_PER_5_VISITORS', 1); define('VISITORS_PER_STAFF_BLOCK', 5); $dailyStaffCostByPPL = [50.0, 60.0, 72.0, 86.0, 104.0]; $baseDailyRentByPPL = ['A' => 60.0, 'B' => 50.0, 'C' => 40.0, 'D' => 30.0, 'E' => 20.0]; define('RENT_INCREASE_PER_BLOCK', 1.20); $cogsPercentage = ['Kafejnīca' => 0.30, 'Restorāns' => 0.35, 'Krogs' => 0.25, 'Frizētava' => 0.15]; define('VAT_RATE', 0.21); define('BASE_DAILY_UTILITIES', 5.0); define('EXTRA_UTILITIES_PER_STAFF_BLOCK', 2.0); define('BASE_DAILY_OTHER_OP', 7.0); define('EXTRA_OTHER_OP_PER_STAFF_BLOCK', 3.0);
    // --- Helper Funkcijas ---
    function getVisitProbability($r, $e){ /* ... NEMAINĪTS ... */ if($r===null||$e===null)return 0.0;$d=abs($r-$e);switch($d){case 0:return 1.0;case 1:return 0.8;case 2:return 0.6;case 3:return 0.4;case 4:return 0.2;default:return 0.0;} }
    function getCompetitorRetentionProbability($d){ /* ... NEMAINĪTS ... */ if($d<=100)return 0.60;if($d<=200)return 0.70;if($d<=300)return 0.75;if($d<=400)return 0.85;if($d<=500)return 0.90;return 1.0;}
    function simpleDistance($la1,$lo1,$la2,$lo2){ /* ... NEMAINĪTS ... */ if($la1==$la2&&$lo1==$lo2)return 0;$eR=6371000;$fLa=deg2rad($la1);$fLo=deg2rad($lo1);$tLa=deg2rad($la2);$tLo=deg2rad($lo2);$dLa=$tLa-$fLa;$dLo=$tLo-$fLo;$a=2*asin(sqrt(pow(sin($dLa/2),2)+cos($fLa)*cos($tLa)*pow(sin($dLo/2),2)));return $a*$eR;}
    // --- AJAX pieprasījumu apstrāde ---
    $response = ['error' => null, 'points' => [], 'points_count' => 0, 'statistics' => [], 'type' => null, 'competitors_found' => [], 'competitor_impact_applied' => false, 'scenario_used' => 'pessimistic', 'radius_used' => 500];
    // 1. Meklēšana rādiusā
    if ($_GET['action'] === 'search') { /* ... Viss search action kods paliek nemainīgs ... */ $response['type'] = 'search_results'; $tableName = 'buildings_geo'; $colEka = 'eka'; $colCilveki = 'cilveki'; $colLevel = 'level'; $colLocation = 'location'; $colName = 'name'; $latClick = isset($_GET['lat']) ? filter_var($_GET['lat'], FILTER_VALIDATE_FLOAT) : false; $lngClick = isset($_GET['lng']) ? filter_var($_GET['lng'], FILTER_VALIDATE_FLOAT) : false; $considerCompetitors = isset($_GET['competitors']) && $_GET['competitors'] === 'true'; $scenario = (isset($_GET['scenario']) && $_GET['scenario'] === 'optimistic') ? 'optimistic' : 'pessimistic'; $radius = 500; if (isset($_GET['radius'])) { $inputRadius = filter_var($_GET['radius'], FILTER_VALIDATE_INT); if ($inputRadius !== false && $inputRadius >= 100 && $inputRadius <= 5000) { $radius = $inputRadius; } else { error_log("PHP WARNING: Invalid radius parameter: " . htmlspecialchars($_GET['radius'])); } } $response['radius_used'] = $radius; $response['scenario_used'] = $scenario; $response['competitor_impact_applied'] = $considerCompetitors; if ($latClick === false || $lngClick === false) { $response['error'] = "Nederīgi koordinātu parametri."; echo json_encode($response); exit; } $centerPointSQL = "POINT(?,?)"; try { $dsn = "mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4"; $pdo = new PDO($dsn, $dbUser, $dbPass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"]); $sqlBuildings = "SELECT `{$colEka}`,`{$colCilveki}`,`{$colLevel}`,ST_Distance_Sphere({$centerPointSQL},`{$colLocation}`)AS distance,ST_Y(`{$colLocation}`)AS disp_lat,ST_X(`{$colLocation}`)AS disp_lng FROM`{$tableName}`WHERE ST_Distance_Sphere({$centerPointSQL},`{$colLocation}`)<=?"; $stmtBuildings = $pdo->prepare($sqlBuildings); if (!$stmtBuildings->execute([$lngClick, $latClick, $lngClick, $latClick, $radius])) { throw new Exception("SQL buildings query failed."); } $buildingsData = []; $total_iedzivotaji = 0; $level_building_counts = array_fill_keys(array_keys($levelColorsPHP), 0); $level_people_counts = array_fill_keys(array_keys($levelColorsPHP), 0); $weightedPPLSum = 0; $totalPeopleForPPL = 0; while ($row = $stmtBuildings->fetch()) { $iedzivotaji_int = (isset($row[$colCilveki]) && is_numeric($row[$colCilveki])) ? intval($row[$colCilveki]) : 0; $level_val = (isset($row[$colLevel]) && isset($levelColorsPHP[strtoupper($row[$colLevel])])) ? strtoupper($row[$colLevel]) : 'NULL'; $lat_float = (isset($row['disp_lat']) && is_numeric($row['disp_lat'])) ? floatval($row['disp_lat']) : null; $lng_float = (isset($row['disp_lng']) && is_numeric($row['disp_lng'])) ? floatval($row['disp_lng']) : null; if ($lat_float !== null && $lng_float !== null) { $levelIndex = ($level_val !== 'NULL' && isset($pplToIndex[$level_val])) ? $pplToIndex[$level_val] : null; $buildingInfo = ['kadastrs' => $row[$colEka] ?? 'N/A', 'iedzivotaji' => $iedzivotaji_int, 'level' => $level_val, 'levelIndex' => $levelIndex, 'distance_from_center' => (isset($row['distance']) && is_numeric($row['distance'])) ? floatval($row['distance']) : null, 'lat' => $lat_float, 'lng' => $lng_float]; $buildingsData[] = $buildingInfo; $response['points'][] = $buildingInfo; $total_iedzivotaji += $iedzivotaji_int; if ($level_val !== 'NULL') { $level_building_counts[$level_val]++; $level_people_counts[$level_val] += $iedzivotaji_int; if ($levelIndex !== null && $iedzivotaji_int > 0) { $weightedPPLSum += ($levelIndex * $iedzivotaji_int); $totalPeopleForPPL += $iedzivotaji_int; } } else { $level_building_counts['NULL']++; } } else { error_log("PHP WARNING (search): Skipped building."); } } $response['points_count'] = count($response['points']); $averageRadiusPPLIndex = null; $averageRadiusPPL = 'C'; if ($totalPeopleForPPL > 0) { $averageRadiusPPLIndex = round($weightedPPLSum / $totalPeopleForPPL); $averageRadiusPPL = $indexToPPL[$averageRadiusPPLIndex] ?? 'C'; } $competitorsInternalData = []; $competitorsResponseData = []; foreach (array_keys($typeToDbTable) as $typeKey) { $competitorsResponseData[$typeKey] = ['count' => 0, 'names' => []]; } if ($considerCompetitors) { foreach ($typeToDbTable as $estType => $compTableName) { $sqlCompetitors = "SELECT`{$colName}`,ST_Y(`{$colLocation}`)AS lat,ST_X(`{$colLocation}`)AS lng FROM`{$compTableName}`WHERE ST_Distance_Sphere({$centerPointSQL},`{$colLocation}`)<=?"; $stmtCompetitors = $pdo->prepare($sqlCompetitors); if (!$stmtCompetitors->execute([$lngClick, $latClick, $radius])) { error_log("PHP WARNING: SQL competitors failed for table: ".$compTableName); continue; } $competitorsInternalData[$estType] = []; while ($compRow = $stmtCompetitors->fetch()) { $compLat = (isset($compRow['lat']) && is_numeric($compRow['lat'])) ? floatval($compRow['lat']) : null; $compLng = (isset($compRow['lng']) && is_numeric($compRow['lng'])) ? floatval($compRow['lng']) : null; $compName = $compRow[$colName] ?? 'N/A'; if ($compLat !== null && $compLng !== null) { $assignedLevel = 'NULL'; $assignedLevelIndex = null; $minDistToBuilding = PHP_FLOAT_MAX; foreach ($buildingsData as $bldg) { if ($bldg['level'] !== 'NULL') { $dist = simpleDistance($compLat, $compLng, $bldg['lat'], $bldg['lng']); if ($dist < $minDistToBuilding) { $minDistToBuilding = $dist; $assignedLevel = $bldg['level']; $assignedLevelIndex = $bldg['levelIndex']; } } } $competitorsInternalData[$estType][] = ['name' => $compName, 'lat' => $compLat, 'lng' => $compLng, 'assigned_level' => $assignedLevel, 'assigned_level_index' => $assignedLevelIndex]; if (isset($competitorsResponseData[$estType])) { $competitorsResponseData[$estType]['names'][] = $compName; $competitorsResponseData[$estType]['count']++; } } } } } $response['competitors_found'] = $competitorsResponseData; $donutColorsPHP = ['A' => 'darkgreen', 'B' => 'lime', 'C' => 'dodgerblue', 'D' => 'orange', 'E' => 'red', 'NULL' => '#AAAAAA']; $statistics_level_building_counts = []; $statistics_level_people_counts = []; $statistics_level_percentages = []; $statistics_level_donut_colors = []; uksort($level_building_counts, function ($a, $b) use ($pplToIndex) { $o=array_flip(array_keys($pplToIndex)); $an=($a==='NULL'); $bn=($b==='NULL'); if($an&&$bn)return 0; if($an)return 1; if($bn)return -1; return ($o[$b]??99) <=> ($o[$a]??99); }); $total_non_null_buildings = 0; foreach($level_building_counts as $l => $c) { if($l !== 'NULL') $total_non_null_buildings += $c; } foreach($level_building_counts as $l => $c) { if ($c > 0) { $statistics_level_building_counts[$l] = $c; $statistics_level_people_counts[$l] = $level_people_counts[$l] ?? 0; if($l !== 'NULL' && $total_non_null_buildings > 0) { $statistics_level_percentages[$l] = round(($c / $total_non_null_buildings) * 100, 1); } elseif ($l === 'NULL') { $statistics_level_percentages[$l] = ($response['points_count'] > 0) ? round(($c / $response['points_count']) * 100, 1) : 0; } else { $statistics_level_percentages[$l] = 0; } $statistics_level_donut_colors[$l] = $donutColorsPHP[$l] ?? '#AAAAAA'; } } $profitability_results = []; if ($total_iedzivotaji > 0) { $visitorsDataSource = $dataScenarios[$scenario]['visitorsPer1000']; $priceDataSource = $dataScenarios[$scenario]['averagePrice']; $investmentDataSource = $dataScenarios[$scenario]['initialInvestment']; foreach ($establishmentTypes as $type) { $profitability_results[$type] = []; for ($estPPLIndex = 0; $estPPLIndex < 5; $estPPLIndex++) { $totalEstimatedVisitors = 0; $establishmentPPL = $indexToPPL[$estPPLIndex]; foreach ($buildingsData as $building) { if ($building['iedzivotaji'] == 0) continue; $resPPLIndex = $building['levelIndex']; if ($resPPLIndex === null) continue; $baseFreq = $visitorsDataSource[$type][$resPPLIndex] ?? 0; $visitorsGenerated = $building['iedzivotaji'] * ($baseFreq / 1000.0); $pplProbability = getVisitProbability($resPPLIndex, $estPPLIndex); $visitorsBeforeComp = $visitorsGenerated * $pplProbability; $competitorReductionFactor = 1.0; if ($considerCompetitors && isset($competitorsInternalData[$type]) && count($competitorsInternalData[$type]) > 0) { $closestCompetitorDist = PHP_FLOAT_MAX; $closestCompetitor = null; foreach ($competitorsInternalData[$type] as $competitor) { $distBuildingToComp = simpleDistance($building['lat'], $building['lng'], $competitor['lat'], $competitor['lng']); if ($distBuildingToComp < $closestCompetitorDist) { $closestCompetitorDist = $distBuildingToComp; $closestCompetitor = $competitor; } } if ($closestCompetitor !== null) { $retentionProbDist = getCompetitorRetentionProbability($closestCompetitorDist); $competitorLevelIndex = $closestCompetitor['assigned_level_index']; if ($competitorLevelIndex !== null && $competitorLevelIndex > $resPPLIndex) { $retentionProbDist *= 0.8; } elseif ($competitorLevelIndex !== null && $competitorLevelIndex < $resPPLIndex) { $retentionProbDist = ($retentionProbDist + 1.0) / 2.0; } $competitorReductionFactor = $retentionProbDist; } } $totalEstimatedVisitors += ($visitorsBeforeComp * $competitorReductionFactor); } $avgVisitorsPerHour = ($totalEstimatedVisitors > 0) ? $totalEstimatedVisitors / (float)WORKING_HOURS_PER_DAY : 0; $staffNeeded = 0; $visitorBlocks = 0; if ($avgVisitorsPerHour > 0) { $visitorBlocks = ceil($avgVisitorsPerHour / (float)VISITORS_PER_STAFF_BLOCK); if ($visitorBlocks == 1) { $staffNeeded = BASE_STAFF_PER_5_VISITORS; } else { $staffNeeded = BASE_STAFF_PER_5_VISITORS + (($visitorBlocks - 1) * EXTRA_STAFF_PER_5_VISITORS); } } $staffCostPerDay = $dailyStaffCostByPPL[$estPPLIndex] ?? 72.0; $cost_staff = $staffNeeded * $staffCostPerDay; $baseRent = $baseDailyRentByPPL[$averageRadiusPPL] ?? 40.0; $cost_rent = $baseRent; if ($visitorBlocks > 1) { $rentIncreaseFactor = pow(RENT_INCREASE_PER_BLOCK, $visitorBlocks - 1); $cost_rent *= $rentIncreaseFactor; } $avgPrice = $priceDataSource[$type][$estPPLIndex] ?? 0; $revenue = $totalEstimatedVisitors * $avgPrice; $cost_cogs = $revenue * ($cogsPercentage[$type] ?? 0.30); $cost_pvn = $revenue - ($revenue / (1 + VAT_RATE)); $cost_utilities = BASE_DAILY_UTILITIES; $cost_other_op = BASE_DAILY_OTHER_OP; if ($visitorBlocks > 0) { $cost_utilities += ($visitorBlocks * EXTRA_UTILITIES_PER_STAFF_BLOCK); $cost_other_op += ($visitorBlocks * EXTRA_OTHER_OP_PER_STAFF_BLOCK); } $baseLoanCost = $baseDailyLoanRepaymentCLevel[$type] ?? 0; $loanAdjustmentFactor = 1.0; switch ($estPPLIndex) { case 0: $loanAdjustmentFactor = 0.60; break; case 1: $loanAdjustmentFactor = 0.80; break; case 3: $loanAdjustmentFactor = 1.20; break; case 4: $loanAdjustmentFactor = 1.40; break; } $cost_loan = $baseLoanCost * $loanAdjustmentFactor; $totalDailyCost = $cost_staff + $cost_rent + $cost_cogs + $cost_pvn + $cost_utilities + $cost_other_op + $cost_loan; $profit = $revenue - $totalDailyCost; $displayInvestment = $investmentDataSource[$type][$estPPLIndex] ?? 0; $profitability_results[$type][$establishmentPPL] = [ 'visitors'=>round($totalEstimatedVisitors,1), 'price'=>$avgPrice, 'revenue'=>round($revenue,2), 'cost_staff'=>round($cost_staff,2), 'cost_rent'=>round($cost_rent,2), 'cost_cogs'=>round($cost_cogs,2), 'cost_pvn'=>round($cost_pvn,2), 'cost_utilities'=>round($cost_utilities,2), 'cost_other_op'=>round($cost_other_op,2), 'cost_loan'=>round($cost_loan,2), 'cost_total'=>round($totalDailyCost,2), 'profit'=>round($profit,2), 'staff_needed'=>$staffNeeded, 'avg_visitors_hour'=>round($avgVisitorsPerHour,1), 'investment'=>$displayInvestment ]; } } } $response['statistics'] = [ 'total_iedzivotaji' => $total_iedzivotaji, 'average_radius_ppl' => $averageRadiusPPL, 'level_percentages' => $statistics_level_percentages, 'level_counts' => $statistics_level_building_counts, 'level_people_counts' => $statistics_level_people_counts, 'level_colors' => $statistics_level_donut_colors, 'profitability_results' => $profitability_results ?? null ]; } catch (PDOException $e) { $response['error'] = "DB Kļūda: " . $e->getMessage(); error_log("PHP PDO ERROR: " . $e->getMessage()); } catch (Exception $e) { $response['error'] = "Servera Kļūda: " . $e->getMessage(); error_log("PHP ERROR: " . $e->getMessage()); }
    // 2. POI ielāde
    } elseif ($_GET['action'] === 'get_points' && isset($_GET['type'])) { /* ... NEMAINĪTS ... */ $type = $_GET['type']; $response['type'] = $type; $tableMap = [ 'cafe' => 'u260470642_cofe', 'food' => 'u260470642_food', 'krogs' => 'u260470642_bar', 'hairdresser' => 'u260470642_frizieri' ]; if (!isset($tableMap[$type])) { $response['error'] = "Nederīgs POI tips."; echo json_encode($response); exit; } $tableName = $tableMap[$type]; $colName = 'name'; $colLocation = 'location'; try { $dsn = "mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4"; $pdo = new PDO($dsn, $dbUser, $dbPass, [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC, PDO::MYSQL_ATTR_INIT_COMMAND=>"SET NAMES utf8mb4"]); $sql = "SELECT`{$colName}`,ST_Y(`{$colLocation}`)AS lat,ST_X(`{$colLocation}`)AS lng FROM`{$tableName}`WHERE ST_Y(`{$colLocation}`)IS NOT NULL AND ST_X(`{$colLocation}`)IS NOT NULL"; $stmt = $pdo->query($sql); $points = []; while ($row = $stmt->fetch()) { $lat_float = (isset($row['lat'])&&is_numeric($row['lat']))?floatval($row['lat']):null; $lng_float = (isset($row['lng'])&&is_numeric($row['lng']))?floatval($row['lng']):null; if ($lat_float !== null && $lng_float !== null) { $points[] = ['name'=>$row[$colName]??'N/A', 'lat'=>$lat_float, 'lng'=>$lng_float]; } else { error_log("PHP WARNING (POI): Skipped POI in table $tableName."); } } $response['points'] = $points; $response['points_count'] = count($points); } catch (PDOException $e) { $response['error'] = "DB Kļūda (POI): " . $e->getMessage(); error_log("PHP PDO ERROR (POI): " . $e->getMessage()); } catch (Exception $e) { $response['error'] = "Servera Kļūda (POI): " . $e->getMessage(); error_log("PHP ERROR (POI): " . $e->getMessage()); } } else { $response['error'] = "Nezināma darbība."; error_log("PHP ERROR: Unknown action specified."); }
    echo json_encode($response);
    exit;
}

// --- FRONTEND: HTML Lapa ---
?>
<!DOCTYPE html>
<html lang="lv">
	<?php include $_SERVER['DOCUMENT_ROOT'] . '/head/head.php'; ?>
<head>
<meta charset="UTF-8">
<title>Biznesa iespēju karte</title>

<meta name="description" content="✅ Atrodi labāko vietu savam biznesam. Nodrošini lielāko cilvēku daudzumu savam uzņēmumam.">
<meta name="keywords" content="savs bizness, biznesa idejas, kafejnīcas atvēršana, restorāna atvēršana, frizētavas atvēršana, kroga atvēršana, iedzīvotāju pirktspēja, cilvēku pirktspēja, iedzīvotāju blīvums">
<link rel="canonical" href="https://saraksts.lv/iespeja" />

	
	<?php include $_SERVER['DOCUMENT_ROOT'] . '/assets/img/icons.php'; ?>
    <meta name="msapplication-TileColor" content="#da532c">
    
    <meta name="theme-color" content="#ffffff">



<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
<link rel="stylesheet" href="/assets/css/main.css" />
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
/* --- CSS Stili, kas attiecas uz pašu kartes lapu --- */
html, body { height: 100%; margin: 0; padding: 0; font-family: sans-serif;}
#map-container { position: relative; width: 100%; height: 100%; }
#map { width: 100%; height: 100%; background-color: #f0f0f0; }

/* --- Paneļu Stili --- */
#controls-container { position: absolute; top: 10px; left: 10px; width: 280px; max-height: calc(100% - 20px); background-color: rgba(255, 255, 255, 0.95); padding: 12px; border: 1px solid #bbb; border-radius: 6px; box-shadow: 0 2px 6px rgba(0,0,0,0.15); z-index: 1000; overflow-y: auto; font-size: 0.85em; }
#analysis-container { position: absolute; top: 10px; right: 10px; width: 420px; max-height: calc(100% - 20px); background-color: rgba(255, 255, 255, 0.95); padding: 12px; border: 1px solid #bbb; border-radius: 6px; box-shadow: 0 2px 6px rgba(0,0,0,0.15); z-index: 1000; overflow-y: auto; font-size: 0.85em; display: none; }

/* --- Vispārīgi Elementi Paneļos --- */
#controls-container h5, #analysis-container h5 { margin-top: 0; margin-bottom: 10px; border-bottom: 1px solid #ccc; padding-bottom: 6px; font-size: 1.05em; color: #333; display: flex; align-items: center; justify-content: space-between; }
#info-sidebar p, #analysis-container p { margin-bottom: 0.5rem; margin-top: 0.2rem; line-height: 1.3; }
#info-sidebar b, #analysis-container b { color: #111; }
hr { margin: 8px 0; border: 0; border-top: 1px solid #ddd; }

/* --- Kreisais Panelis Specifiski --- */
#radius-label-container { display: flex; align-items: center; margin-bottom: 5px; }
#radius-label-container label { margin-bottom: 0; font-weight: bold; flex-grow: 1; }
#radius-toggle-btn { cursor: pointer; background: none; border: none; font-size: 1.1em; padding: 0 5px; color: #555; margin-left: 5px; }
#radius-toggle-btn:hover { color: #000; }
#radius-controls-collapsible { display: none; margin-top: 5px; padding-top: 5px; border-top: 1px dashed #eee; }
#radius-controls-collapsible .slider-container { display: flex; align-items: center; }
#radius-controls-collapsible input[type="range"] { flex-grow: 1; margin-right: 8px; cursor: pointer; height: 5px;}
#radius-controls-collapsible input[type="number"] { width: 60px; text-align: right; margin-right: 3px; font-size: 0.95em; padding: 2px 4px;}

/* Konteiners diagrammai un leģendai */
#chart-legend-wrapper { display: flex; align-items: flex-start; gap: 10px; margin-top: 8px; margin-bottom: 15px; }
#chart-container { flex: 0 0 120px; height: 120px; position: relative; }
#levelDonutChart { display: block; max-width: 100%; max-height: 100%; width: 100% !important; height: 100% !important;}

/* Pielāgotā leģenda (ar vertikālu izkārtojumu) */
#custom-legend { flex: 1; list-style: none; padding: 0; margin: 0; font-size: 0.8em; line-height: 1.4; }
#custom-legend li { display: flex; align-items: flex-start; margin-bottom: 4px; }
.legend-color-box { width: 10px; height: 10px; display: inline-block; margin-right: 6px; border: 1px solid #ccc; flex-shrink: 0; margin-top: 2px; }
.legend-details { display: flex; flex-direction: column; } /* Vertikāli */
.legend-text { font-weight: bold; }
.legend-stats { color: #555; }
.legend-percent { font-weight: normal; margin-right: 3px; }
.legend-count { font-size: 0.9em; }

#layer-controls h5 { font-size: 1em; margin-bottom: 8px;}
#layer-controls label { display: block; margin-bottom: 4px; cursor: pointer; font-size: 0.95em;}
#layer-controls input[type="checkbox"] { margin-right: 6px; vertical-align: middle; }
.poi-legend i { margin-right: 5px; width: 12px; text-align: center; }
.poi-loading { color: #888; margin-left: 5px; font-size: 0.9em; }

/* --- Labais Panelis Specifiski --- */
#analysis-container h6 { font-size: 1em; margin-bottom: 6px; margin-top: 10px; padding-bottom: 4px; border-bottom: 1px dashed #ddd; color: #444; }
#analysis-options { display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px; padding-bottom: 8px; border-bottom: 1px solid #eee; flex-wrap: wrap; gap: 10px; }
#analysis-options > div { margin-bottom: 0; }
#competitor-options label { font-weight: normal; cursor: pointer; font-size: 0.95em; }
#competitor-options input { vertical-align: middle; margin-right: 4px; }
#scenario-options { display: flex; align-items: center; gap: 5px; }
#scenario-options b { font-weight: bold; margin-right: 2px; font-size: 0.95em; } /* Scenārijs: */
#scenario-options label { margin-left: 0; font-weight: normal; cursor: pointer; font-size: 0.95em; white-space: nowrap; }
#scenario-options input { vertical-align: middle; margin-right: 3px; }

/* PPL Eiro Simbolu Stili */
.ppl-euro-wrapper { display: inline-block; white-space: nowrap; line-height: 1; }
.ppl-euro-symbol { font-weight: bold; font-size: 1em; margin: 0 0px; display: inline-block; padding: 0 1px; }
.ppl-euro-symbol.gold { color: #FFBF00; /* Zeltaināks */ }
.ppl-euro-symbol.grey { color: #B0B0B0; /* Nedaudz tumšāks pelēks */ }

/* Tabulu Stili (Pielāgoti PPL Eiro simboliem) */
.competitor-summary-table, .profit-summary-table, .profit-details-table { width: 100%; border-collapse: collapse; margin-bottom: 12px; font-size: 0.85em; }
.competitor-summary-table th, .competitor-summary-table td,
.profit-summary-table th, .profit-summary-table td,
.profit-details-table th, .profit-details-table td { border: 1px solid #e8e8e8; padding: 3px 2px; text-align: center; vertical-align: middle; }
.competitor-summary-table th, .profit-summary-table th, .profit-details-table th { background-color: #f9f9f9; font-weight: bold; white-space: nowrap; padding: 4px 2px; }
.profit-summary-table td.profit-value { font-weight: bold; }
.profit-summary-table td.profit-positive, .profit-details-table .profit-positive { color: green; font-weight: bold;}
.profit-summary-table td.profit-negative, .profit-details-table .profit-negative { color: red; font-weight: bold;}
.profit-summary-table td.profit-zero, .profit-details-table .profit-zero { color: #555; }

/* Specifiski Konkurentu Tabulai */
.competitor-summary-table th:nth-child(1), .competitor-summary-table td:nth-child(1) { width: 65px; text-align: left; padding-left: 4px;} /* Tips */
.competitor-summary-table th:nth-child(2), .competitor-summary-table td:nth-child(2) { width: 40px; text-align: right; padding-right: 4px; } /* Skaits */
.competitor-summary-table th:nth-child(3), .competitor-summary-table td:nth-child(3) { text-align: left; padding-left: 4px; vertical-align: top;} /* Konkurenti */

/* Specifiski Peļņas Kopsavilkuma Tabulai */
.profit-summary-table th:first-child { width: 90px; text-align: left; padding-left: 4px;} /* Iestādes līmenis */
.profit-summary-table th:not(:first-child) { width: 55px; } /* PPL € simboli */
.profit-summary-table td:first-child { text-align: left; padding-left: 4px; font-weight: bold; } /* Iestādes tips */

/* Specifiski Peļņas Detaļu Tabulai */
.profit-details-table th:first-child { width: 55px; } /* Virsraksts "PPL" */
.profit-details-table td:first-child { width: 55px; padding-top: 5px; padding-bottom: 5px;} /* PPL € simboli */
.profit-details-table th:nth-child(n+4), .profit-details-table td:nth-child(n+4) { font-size: 0.9em; }
.profit-details-table th:last-child, .profit-details-table td:last-child { width: 55px; } /* Invest. kolonna */

#profit-details-container { display: none; margin-top: 8px; }
#toggle-details-btn { display: block; margin: 8px auto; padding: 4px 8px; background-color: #f0f0f0; border: 1px solid #ccc; border-radius: 4px; cursor: pointer; text-align: center; font-size: 0.85em; width: auto; }
#toggle-details-btn:hover { background-color: #e0e0e0; }

/* Citi Stili */
.loading-text { text-align: center; color: #555; font-style: italic; padding: 10px 0; }
.error-text { color: #D8000C; background-color: #FFD2D2; padding: 8px; border-radius: 4px; margin-top: 5px; font-weight: bold; font-size: 0.9em; }
.awesome-marker-icon { text-align: center; }
.small-note { font-size: 0.85em; color: #666; margin-top: 5px; display: block; text-align: center;}
</style>
</head>
<body>

<?php include $_SERVER['DOCUMENT_ROOT'] . '/header.php'; ?>

<div id="map-container">
<div id="map"></div>
<div id="controls-container">
<div id="info-sidebar">
    <h5>
        <span>Kopsavilkums</span>
    </h5>
    <div id="radius-label-container">
        <label for="radius-slider">Analīzes rādiuss:</label>
        <button id="radius-toggle-btn" title="Rādīt/Slēpt rādiusa izvēli">▼</button>
    </div>
    <div id="radius-controls-collapsible">
        <div class="slider-container">
            <input type="range" id="radius-slider" min="100" max="5000" step="50" value="500">
            <input type="number" id="radius-input" min="100" max="5000" step="50" value="500">
            <span>m</span>
        </div>
    </div>
    <p id="click-prompt" style="font-style: italic; color: #666; text-align: center; margin-top: 15px;">Noklikšķiniet uz kartes, lai sāktu analīzi...</p>
    <div id="sidebar-content"></div>
</div>
<hr>
<div id="layer-controls">
    <h5>Rādīt POI:</h5>
    <label><input type="checkbox" id="cb-cafe" value="cafe"> <i class="fas fa-coffee poi-legend" style="color: brown;"></i> Kafejnīcas</label>
    <label><input type="checkbox" id="cb-food" value="food"> <i class="fas fa-utensils poi-legend" style="color: darkorange;"></i> Restorāni</label>
    <label><input type="checkbox" id="cb-krogs" value="krogs"> <i class="fas fa-beer-mug-empty poi-legend" style="color: purple;"></i> Krogi</label>
    <label><input type="checkbox" id="cb-hairdresser" value="hairdresser"> <i class="fas fa-cut poi-legend" style="color: deeppink;"></i> Frizētavas</label>
</div>
</div>

<div id="analysis-container"></div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
<script>
// --- Globālie mainīgie un Inicializācija ---
var mapCenter = [56.9496, 24.1052]; var map = L.map('map').setView(mapCenter, 13);
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19, attribution: '© OpenStreetMap' }).addTo(map);
var searchCircle; var buildingMarkersLayer = L.layerGroup().addTo(map);
var cafeLayer = L.layerGroup(), foodLayer = L.layerGroup(), krogsLayer = L.layerGroup(), hairdresserLayer = L.layerGroup();
// Krāsas Donut diagrammai
var donutLevelColors = { 'A': 'darkgreen', 'B': 'lime', 'C': 'dodgerblue', 'D': 'orange', 'E': 'red', 'NULL': '#AAAAAA' };
// Krāsas PPL € simboliem
const goldColor = '#FFBF00';
const greyColor = '#B0B0B0';
var defaultBuildingColor = '#555555';
var levelDescriptions = { 'A': 'Maksimāla', 'B': 'Augsta', 'C': 'Vidēja', 'D': 'Zema', 'E': 'Minimāla', 'NULL': 'Nezināma' };

function createAwesomeIcon(iconName, markerColor) { return L.divIcon({ html: `<i class="fas ${iconName}" style="color: ${markerColor}; font-size: 16px; text-shadow: 1px 1px 2px rgba(0,0,0,0.3);"></i>`, iconSize: [18, 18], className: 'awesome-marker-icon'}); }
var poiIcons = { 'cafe': createAwesomeIcon('fa-coffee', 'brown'), 'food': createAwesomeIcon('fa-utensils', 'darkorange'), 'krogs': createAwesomeIcon('fa-beer-mug-empty', 'purple'), 'hairdresser': createAwesomeIcon('fa-cut', 'deeppink') };
var poiDataCache = { cafe: null, food: null, krogs: null, hairdresser: null };
var currentDonutChart = null; var lastClickCoords = null; var currentRadius = 500;

// --- Funkcijas ---

// PPL Eiro Simbolu ģenerēšana
function generatePplEuroSymbols(level) {
    const levelMap = { 'E': 1, 'D': 2, 'C': 3, 'B': 4, 'A': 5 };
    const numGold = levelMap[level] || 0;
    const numGrey = 5 - numGold;
    let iconsHtml = '<span class="ppl-euro-wrapper" title="Līmenis ' + level + '">';
    for (let i = 0; i < numGold; i++) { iconsHtml += `<span class="ppl-euro-symbol gold" style="color:${goldColor};">€</span>`; }
    for (let i = 0; i < numGrey; i++) { iconsHtml += `<span class="ppl-euro-symbol grey" style="color:${greyColor};">€</span>`; }
    iconsHtml += '</span>';
    return iconsHtml;
}

// displayBuildingPoints
function displayBuildingPoints(points) { /* ... nemainīgs ... */ console.log("JS: displayBuildingPoints", points ? points.length : 0); buildingMarkersLayer.clearLayers(); if (!points || points.length === 0) return; let v = 0; points.forEach(function(p, i) { try { let lat = parseFloat(p.lat); let lng = parseFloat(p.lng); if (isNaN(lat) || isNaN(lng)) return; let iedz = parseInt(p.iedzivotaji, 10) || 0; let clr = donutLevelColors[p.level] || defaultBuildingColor; let r = 3 + Math.log(Math.max(1, iedz) + 1) * 1.5; r = Math.min(r, 15); let m = L.circle([lat, lng], { radius: r, color: clr, weight: 1, fillColor: clr, fillOpacity: 0.65 }); let pop = `<b>Ēka:</b> ${p.kadastrs || 'N/A'}<br><b>Iedz.:</b> ${iedz}<br><b>Līm.:</b> ${p.level || 'Nez.'}<br><b>Attāl.:</b> ${p.distance_from_center !== null ? Math.round(p.distance_from_center) + " m" : "N/A"}`; m.bindPopup(pop, {offset: L.point(0, -r)}); buildingMarkersLayer.addLayer(m); v++; } catch(e) { console.error(`JS(Bldg) Err ${i}:`, p, e); } }); console.log(`JS: Ēkas kartē: ${v} no ${points.length}`); }

// displayPoiPoints
function displayPoiPoints(points, type) { /* ... nemainīgs ... */ console.log(`JS: displayPoiPoints '${type}'`, points ? points.length : 0); var lyr; var ico; switch(type) { case 'cafe': lyr = cafeLayer; ico = poiIcons.cafe; break; case 'food': lyr = foodLayer; ico = poiIcons.food; break; case 'krogs': lyr = krogsLayer; ico = poiIcons.krogs; break; case 'hairdresser': lyr = hairdresserLayer; ico = poiIcons.hairdresser; break; default: return; } lyr.clearLayers(); if (!points || points.length === 0) { if (map.hasLayer(lyr)) map.removeLayer(lyr); return; } let v = 0; points.forEach(function(p, i) { try { let lat = parseFloat(p.lat); let lng = parseFloat(p.lng); if (isNaN(lat) || isNaN(lng)) return; let m = L.marker([lat, lng], { icon: ico }).bindPopup(`<b>${p.name || 'Bez nosaukuma'}</b>`); lyr.addLayer(m); v++; } catch(e) { console.error(`JS(POI ${type}) Err ${i}:`, p, e); } }); console.log(`JS: '${type}' POI punkti kartē: ${v}`); if ($(`#cb-${type}`).is(':checked')) { if (!map.hasLayer(lyr)) map.addLayer(lyr); } else { if (map.hasLayer(lyr)) map.removeLayer(lyr); } }

// updateSidebar
function updateSidebar(data) { /* ... nemainīgs ... */ var sidebarContent = $("#sidebar-content"); sidebarContent.empty(); $('#click-prompt').hide(); if (currentDonutChart) { currentDonutChart.destroy(); currentDonutChart = null; } if (data.error || !data.statistics) { sidebarContent.append(`<p class="error-text">${data.error || 'Trūkst statistikas datu.'}</p>`); return; } var stats = data.statistics; var pointsCount = data.points_count ?? 0; var totalIedzivotaji = stats.total_iedzivotaji ?? 0; let summaryHtml = `<p style="margin-bottom: 0.3rem;">Atrastās ēkas: <b>${pointsCount}</b></p>`; summaryHtml += `<p style="margin-bottom: 0.3rem;">Kop. iedzīvotāji: <b>${totalIedzivotaji}</b></p>`; if(stats.average_radius_ppl) { summaryHtml += `<p>Vid. PPL rajonā: <b style="color:${donutLevelColors[stats.average_radius_ppl] || 'black'}">${stats.average_radius_ppl}</b></p>`; } sidebarContent.append(summaryHtml); if (stats.level_percentages && stats.level_colors && Object.keys(stats.level_percentages).length > 0) { sidebarContent.append("<hr style='margin: 5px 0;'><p style='margin-bottom: 5px;'><b>Iedzīvotāju pirktspējas līmenis:</b></p>"); sidebarContent.append('<div id="chart-legend-wrapper"><div id="chart-container"><canvas id="levelDonutChart"></canvas></div><ul id="custom-legend"></ul></div>'); const chartLabels = Object.keys(stats.level_percentages); const chartDataValues = chartLabels.map(label => stats.level_percentages[label] || 0); const chartBackgroundColors = chartLabels.map(label => stats.level_colors[label] || defaultBuildingColor); const chartConfig = { type: 'doughnut', data: { labels: chartLabels.map(l => (levelDescriptions[l] || l) + ' pirktspēja'), datasets: [{ data: chartDataValues, backgroundColor: chartBackgroundColors, borderColor: '#ffffff', borderWidth: 1 }] }, options: { responsive: true, maintainAspectRatio: false, cutout: '65%', plugins: { legend: { display: false }, tooltip: { enabled: false } } } }; var ctx = document.getElementById('levelDonutChart')?.getContext('2d'); if (ctx) { currentDonutChart = new Chart(ctx, chartConfig); } var legendHtml = ''; chartLabels.forEach(level => { if (stats.level_percentages[level] !== undefined) { let color = stats.level_colors[level] || defaultBuildingColor; let description = levelDescriptions[level] || level; let percentage = stats.level_percentages[level] || 0; let peopleCount = stats.level_people_counts[level] || 0; legendHtml += `<li><span class="legend-color-box" style="background-color: ${color};"></span><div class="legend-details"><span class="legend-text">${description} pirktspēja</span><div class="legend-stats"><span class="legend-percent">${percentage.toFixed(1)}%</span><span class="legend-count">(${peopleCount} iedz.)</span></div></div></li>`; } }); $('#custom-legend').html(legendHtml); } else if (pointsCount > 0) { sidebarContent.append("<p class='small-note' style='margin-top: 10px;'>Nav datu par PPL sadalījumu.</p>"); } if (pointsCount === 0) { sidebarContent.append("<p class='small-note' style='margin-top: 10px;'>Nav atrasta neviena ēka.</p>"); } }

// updateAnalysisPanel
function updateAnalysisPanel(data) { /* ... nemainīgs ... */ var analysisContainer = $("#analysis-container"); analysisContainer.empty().hide(); if (data.error || !data.statistics) { return; } var stats = data.statistics; var totalIedzivotaji = stats.total_iedzivotaji ?? 0; var scenarioUsed = data.scenario_used || 'pessimistic'; var competitorImpactApplied = data.competitor_impact_applied; var radiusUsed = data.radius_used || currentRadius; analysisContainer.append(`<h5>Biznesa Analīze (Rādiuss: ${radiusUsed}m)</h5>`); analysisContainer.append(`<div id="analysis-options"><div id="competitor-options"><label><input type="checkbox" id="cb-competitors" ${competitorImpactApplied ? 'checked' : ''}> Iekļaut konkurentus</label></div><div id="scenario-options"><b>Scenārijs:</b> <label><input type="radio" name="scenario" value="pessimistic" ${scenarioUsed === 'pessimistic' ? 'checked' : ''}> Pesim.</label> <label><input type="radio" name="scenario" value="optimistic" ${scenarioUsed === 'optimistic' ? 'checked' : ''}> Optim.</label></div></div><div id="competitor-section" style="margin-bottom: 8px;"></div><div id="profitability-section"></div>`); var competitorSection = analysisContainer.find("#competitor-section"); var profitabilitySection = analysisContainer.find("#profitability-section"); if (data.competitors_found) { competitorSection.append('<h6>Konkurenti rādiusā</h6>'); var compSummaryHtml = '<table class="competitor-summary-table"><thead><tr><th>Tips</th><th>Skaits</th><th>Konkurenti</th></tr></thead><tbody>'; var hasAnyCompetitors = false; var competitorTypesDisplay = { 'Kafejnīca': 'Kafejnīcas', 'Restorāns': 'Restorāni', 'Krogs': 'Krogi', 'Frizētava': 'Frizētavas' }; Object.keys(competitorTypesDisplay).forEach(typeKey => { var compData = data.competitors_found[typeKey]; var count = compData?.count ?? 0; var names = compData?.names ?? []; var namesHtml = '-'; if (count > 0 && names.length > 0) { hasAnyCompetitors = true; namesHtml = names.map(name => $('<div>').text(name).html()).join(', '); } compSummaryHtml += `<tr><td>${competitorTypesDisplay[typeKey]}</td><td>${count}</td><td>${namesHtml}</td></tr>`; }); compSummaryHtml += '</tbody></table>'; competitorSection.append(compSummaryHtml); if (!hasAnyCompetitors && competitorImpactApplied) { competitorSection.append('<p class="small-note" style="margin-top:-8px;">(Neviens konkurents nav atrasts)</p>'); } else if (!competitorImpactApplied) { competitorSection.append('<p class="small-note" style="margin-top:-8px;">(Konkurentu ietekme nav ieslēgta)</p>'); } } else { competitorSection.append('<p class="small-note">Konkurentu dati nav ielādēti.</p>'); } if (totalIedzivotaji > 0 && stats.profitability_results) { var impactText = competitorImpactApplied ? "ar konkurentiem" : "bez konkurentiem"; var scenarioText = (scenarioUsed === 'optimistic') ? 'Optimistiski' : 'Pesimistiski'; profitabilitySection.append(`<h6>Biznesa Potenciāls (Dienas ieņēmumi P/Z, €)</h6><p class='small-note' style='margin-top:-4px; margin-bottom: 6px;'>(${scenarioText}, ${impactText})</p>`); var profitData = stats.profitability_results; var establishmentTypesDisplay = {'Kafejnīca': 'Kafejnīca','Restorāns': 'Restorāns','Krogs': 'Krogs','Frizētava': 'Frizētava'}; var pplLevels = ['E', 'D', 'C', 'B', 'A']; var summaryHtml = '<table class="profit-summary-table"><thead><tr><th>Iestādes līmenis</th>'; pplLevels.forEach(level => summaryHtml += `<th title="Līmenis ${level}">${generatePplEuroSymbols(level)}</th>`); summaryHtml += '</tr></thead><tbody>'; Object.keys(establishmentTypesDisplay).forEach(typeKey => { if(profitData[typeKey]) { summaryHtml += `<tr><td>${establishmentTypesDisplay[typeKey]}</td>`; pplLevels.forEach(level => { var profit = profitData[typeKey]?.[level]?.profit; var profitClass = 'profit-zero'; var profitText = '-'; if (typeof profit === 'number') { profitText = profit.toFixed(1); if (profit > 0.05) profitClass = 'profit-positive'; else if (profit < -0.05) profitClass = 'profit-negative'; } summaryHtml += `<td class="profit-value ${profitClass}">${profitText}</td>`; }); summaryHtml += '</tr>'; } }); summaryHtml += '</tbody></table>'; profitabilitySection.append(summaryHtml); profitabilitySection.append('<button id="toggle-details-btn">Rādīt/Slēpt Detaļas</button>'); var detailsHtml = '<div id="profit-details-container">'; Object.keys(establishmentTypesDisplay).forEach(typeKey => { if(profitData[typeKey]) { detailsHtml += `<h6 style='font-size: 0.9em; margin-bottom: 4px;'>${establishmentTypesDisplay[typeKey]} - Detaļas</h6>`; detailsHtml += `<table class="profit-details-table"><thead><tr><th>PPL</th><th title="Apmeklētāji dienā">Apm.</th><th title="Ieņēmumi dienā (€)">Ieņ.</th> <th class="cost-col-head" title="Personāla izmaksas (€)">Pers</th><th class="cost-col-head" title="Nomas izmaksas (€)">Noma</th><th class="cost-col-head" title="Izejvielu/Materiālu izmaksas (€)">COGS</th><th class="cost-col-head" title="PVN (€)">PVN</th><th class="cost-col-head" title="Komunālie/Citi izdevumi (€)">Citi</th><th class="cost-col-head" title="Kredīta maksājums (€)">Kred.</th> <th title="Peļņa/Zaudējumi dienā (€)">P/Z</th><th title="Aptuvenās sākotnējās investīcijas (€)">Invest.</th></tr></thead><tbody>`; pplLevels.forEach(level => { var d = profitData[typeKey]?.[level]; var profit = d?.profit; var profitClass = 'profit-zero'; if (typeof profit === 'number') { if (profit > 0.05) profitClass = 'profit-positive'; else if (profit < -0.05) profitClass = 'profit-negative'; } let visitors = d?.visitors ?? '-'; if (typeof visitors === 'number') visitors = visitors.toFixed(1); let revenue = d?.revenue?.toFixed(1) ?? '-'; let staff = d?.cost_staff?.toFixed(1) ?? '-'; let rent = d?.cost_rent?.toFixed(1) ?? '-'; let cogs = d?.cost_cogs?.toFixed(1) ?? '-'; let pvn = d?.cost_pvn?.toFixed(1) ?? '-'; let other = ((d?.cost_utilities ?? 0) + (d?.cost_other_op ?? 0)).toFixed(1); let loan = d?.cost_loan?.toFixed(1) ?? '-'; let profitVal = profit?.toFixed(1) ?? '-'; let investment = d?.investment?.toLocaleString('lv-LV', {maximumFractionDigits: 0}) ?? '-'; detailsHtml += `<tr><td>${generatePplEuroSymbols(level)}</td> <td>${visitors}</td><td>${revenue}</td> <td class="cost-col">${staff}</td><td class="cost-col">${rent}</td><td class="cost-col">${cogs}</td><td class="cost-col">${pvn}</td><td class="cost-col">${other}</td><td class="cost-col">${loan}</td> <td class="${profitClass}">${profitVal}</td><td>${investment}</td></tr>`; }); detailsHtml += '</tbody></table>'; } }); detailsHtml += '</div>'; profitabilitySection.append(detailsHtml); } else if (totalIedzivotaji <= 0 && pointsCount > 0) { profitabilitySection.append('<p class="small-note">Peļņas aprēķins nav iespējams (nav iedzīvotāju).</p>'); } else if (pointsCount === 0) { profitabilitySection.append('<p class="small-note">Peļņas aprēķins nav iespējams (nav ēku).</p>'); } else { profitabilitySection.append('<p class="small-note">Peļņas dati nav pieejami.</p>'); } analysisContainer.fadeIn(); }

// triggerSearchRequest
function triggerSearchRequest() { /* ... nemainīgs ... */ if (!lastClickCoords) { return; } var clickLat = lastClickCoords.lat; var clickLng = lastClickCoords.lng; var considerCompetitors = $('#analysis-container').is(':visible') ? $('#cb-competitors').is(':checked') : true; var selectedScenario = $('#analysis-container').is(':visible') ? $('input[name="scenario"]:checked').val() : 'pessimistic'; var selectedRadius = currentRadius; console.log(`JS: Izsauc AJAX search (Lat: ${clickLat.toFixed(4)}, Lng: ${clickLng.toFixed(4)}, Radius: ${selectedRadius}, Competitors: ${considerCompetitors}, Scenario: ${selectedScenario})`); $("#sidebar-content").html('<p class="loading-text"><i class="fas fa-spinner fa-spin"></i> Meklē datus...</p>'); $('#click-prompt').hide(); if ($("#analysis-container").is(':visible')) { $("#analysis-container").hide().empty(); } if (currentDonutChart) { currentDonutChart.destroy(); currentDonutChart = null; } buildingMarkersLayer.clearLayers(); if (searchCircle) { map.removeLayer(searchCircle); searchCircle = null; } searchCircle = L.circle([clickLat, clickLng], { radius: selectedRadius, color: 'blue', weight: 1, fillOpacity: 0.05, interactive: false }).addTo(map); 
    
    // === AJAX PIEPRASĪJUMS ATJAUNINĀTS ===
    $.getJSON('iespeja.php', { action: 'search', lat: clickLat, lng: clickLng, radius: selectedRadius, competitors: considerCompetitors, scenario: selectedScenario }) 
    .done(function(data) { console.log("JS: AJAX atbilde (search):", data); if (data && data.type === 'search_results') { currentRadius = data.radius_used || selectedRadius; if ($('#radius-input').val() != currentRadius) { $('#radius-slider').val(currentRadius); $('#radius-input').val(currentRadius); } updateSidebar(data); updateAnalysisPanel(data); if (!data.error && data.points?.length > 0) { displayBuildingPoints(data.points); } else { buildingMarkersLayer.clearLayers(); } } else { updateSidebar({ error: data.error || "Negaidīta servera atbilde." }); $("#analysis-container").hide().empty(); } }) .fail(function(jqXHR, textStatus, errorThrown) { console.error("JS: AJAX kļūda (search):", textStatus, errorThrown, jqXHR.responseText); var errorMsg = `Kļūda saziņā ar serveri (${textStatus}). Mēģiniet vēlreiz vēlāk.`; try { let responseData = JSON.parse(jqXHR.responseText); if (responseData && responseData.error) { errorMsg = responseData.error; } } catch(e) {} $("#sidebar-content").html(`<p class="error-text">${errorMsg}</p>`); $("#analysis-container").hide().empty(); }); }


// --- Event Listeners ---

// Klikšķis uz kartes
map.on('click', function(e) { lastClickCoords = { lat: e.latlng.lat, lng: e.latlng.lng }; triggerSearchRequest(); });

// Rādiusa kontroles
$('#radius-slider').on('input', function() { let value = $(this).val(); $('#radius-input').val(value); });
$('#radius-slider').on('change', function() { currentRadius = parseInt($(this).val(), 10); if (lastClickCoords) { triggerSearchRequest(); } });
$('#radius-input').on('change', function() { let value = parseInt($(this).val(), 10); const min = parseInt($(this).attr('min'), 10); const max = parseInt($(this).attr('max'), 10); if (isNaN(value) || value < min) { value = min; } else if (value > max) { value = max; } $(this).val(value); $('#radius-slider').val(value); currentRadius = value; if (lastClickCoords) { triggerSearchRequest(); } });
$('#radius-toggle-btn').on('click', function() { $('#radius-controls-collapsible').slideToggle(200); $(this).text($(this).text() === '▼' ? '▲' : '▼'); });

// POI Checkbox
$('#layer-controls input[type="checkbox"]').on('change', function() { /* ... nemainīgs ... */ var checkbox = $(this); var type = checkbox.val(); var isChecked = checkbox.is(':checked'); var targetLayer; switch(type) { case 'cafe': targetLayer = cafeLayer; break; case 'food': targetLayer = foodLayer; break; case 'krogs': targetLayer = krogsLayer; break; case 'hairdresser': targetLayer = hairdresserLayer; break; default: return; } if (isChecked) { if (poiDataCache[type]) { displayPoiPoints(poiDataCache[type], type); } else { let loadingIcon = ' <i class="fas fa-spinner fa-spin poi-loading" title="Ielādē..."></i>'; checkbox.parent().append(loadingIcon); 
    
    // === AJAX PIEPRASĪJUMS ATJAUNINĀTS ===
    $.getJSON('iespeja.php', { action: 'get_points', type: type }) 
    .done(function(data) { if (data && data.type === type && !data.error && data.points !== undefined) { poiDataCache[type] = data.points; displayPoiPoints(data.points, type); } else { poiDataCache[type] = []; targetLayer.clearLayers(); if (map.hasLayer(targetLayer)) map.removeLayer(targetLayer); checkbox.prop('checked', false); console.error(`POI load error for ${type}: ${data.error || 'Unknown error'}`); } }).fail(function() { checkbox.prop('checked', false); poiDataCache[type] = []; targetLayer.clearLayers(); if (map.hasLayer(targetLayer)) map.removeLayer(targetLayer); }).always(function() { $('.poi-loading', checkbox.parent()).remove(); }); } } else { if (map.hasLayer(targetLayer)) { map.removeLayer(targetLayer); } } });

// Citi Event Listeners (labajam panelim)
$(document).on('change', '#cb-competitors', function() { if (lastClickCoords) triggerSearchRequest(); });
$(document).on('change', 'input[name="scenario"]', function() { if (lastClickCoords) triggerSearchRequest(); });
$(document).on('click', '#toggle-details-btn', function() { $('#profit-details-container').slideToggle(200); });

// Sākuma stāvoklis
$(document).ready(function() {
    currentRadius = parseInt($('#radius-slider').val(), 10); $('#radius-input').val(currentRadius);
    $("#sidebar-content").empty(); $('#click-prompt').show(); $("#analysis-container").hide();
    $('#radius-controls-collapsible').hide(); $('#radius-toggle-btn').text('▼');
});

</script>
<?php include $_SERVER['DOCUMENT_ROOT'] . '/cookie/cookie.php'; ?>
</body>
</html>