// projects/python_generator/templates/assets/js/main.js

import { initializeAllRatioCharts } from './modules/financial_ratios_module.js';
import { init as initIndustryCharts } from './modules/industry_charts.js';
import { initializeTooltips } from './tooltip.js';
import { initChartsController } from './charts_controller.js';
import { initLiveSearch } from './live_search.js';
import { init as initAutocomplete } from './autocomplete.js';

/**
 * Dinamiski ielādē skriptu un atgriež Promise.
 * @param {string} src Skripta URL
 * @returns {Promise<void>}
 */
function loadScript(src) {
    return new Promise((resolve, reject) => {
        const script = document.createElement('script');
        script.src = src;
        script.onload = () => resolve();
        script.onerror = () => reject(new Error(`Script load error for ${src}`));
        document.head.appendChild(script);
    });
}

document.addEventListener('DOMContentLoaded', async function() {
    try {
        // --- SĀKUMS: JAUNAIS KODS HAMBURGER IZVĒLNEI ---
        const menuToggle = document.getElementById('menu-toggle');
        const mainNav = document.getElementById('main-nav');
        
        if (menuToggle && mainNav) {
            // Atrodam ikonu pogas iekšienē
            const menuIcon = menuToggle.querySelector('i');

            menuToggle.addEventListener('click', function() {
                // Pārslēdz klasi navigācijas blokam
                mainNav.classList.toggle('is-open');
                
                // Pārslēdz klasi pašai pogai (lai mainītu ikonu)
                this.classList.toggle('is-open');
                
                // Maina pieejamības atribūtu
                const isExpanded = mainNav.classList.contains('is-open');
                this.setAttribute('aria-expanded', isExpanded);
                
                // Maina ikonu no ☰ uz X un atpakaļ
                if (isExpanded) {
                    menuIcon.classList.remove('fa-bars');
                    menuIcon.classList.add('fa-times');
                    this.setAttribute('aria-label', 'Aizvērt izvēlni');
                } else {
                    menuIcon.classList.remove('fa-times');
                    menuIcon.classList.add('fa-bars');
                    this.setAttribute('aria-label', 'Atvērt izvēlni');
                }
            });
        }
        // --- BEIGAS: JAUNAIS KODS HAMBURGER IZVĒLNEI ---

        // Pirmkārt, ielādējam D3 bibliotēkas un sagaidām, kad tās būs gatavas.
        await loadScript('https://cdnjs.cloudflare.com/ajax/libs/d3/7.9.0/d3.min.js');
        await loadScript('https://cdnjs.cloudflare.com/ajax/libs/d3-sankey/0.12.3/d3-sankey.min.js');

        // Pārbauda, vai galvenais konfigurācijas objekts no Python ir pieejams
        if (typeof config === 'undefined') {
            console.error("Kļūda: Globālais konfigurācijas objekts 'config' nav definēts!");
            return; // Pārtraucam izpildi, ja nav konfigurācijas
        }

        // Tagad, kad D3 ir ielādēts, inicializējam pārējos moduļus
        
        // Finanšu rādītāju diagrammas
        if (config.ratiosHistory) {
            initializeAllRatioCharts(config);
        }

        // Nozaru salīdzināšanas diagrammas
        if (document.getElementById('industry_chart_scatter')) {
            initIndustryCharts(config);
        }
        
        // Rīka padomi (Tooltips)
        initializeTooltips();

        // Galvenais diagrammu kontrolieris (Sankey, Bilance, Kopsavilkums)
        if (config.sankeyAvailableYears) {
            initChartsController();
        }

        // "Live" meklēšana galvenajā meklēšanas laukā
        if (document.getElementById('searchInput')) {
            initLiveSearch();
        }

        // Autocomplete funkcionalitāte (ja ir)
        if (document.getElementById('search_term')) {
            const autocompleteConfig = {
                 baseActionUrl: config.baseActionUrl || '',
                 minAutocompleteChars: config.minAutocompleteChars || 2,
                 maxSearchTermLength: config.maxSearchTermLength || 100
            };
            initAutocomplete(autocompleteConfig);
        }

        // Pārējais kods, kas apstrādā gadījumus, ja diagrammu dati nav pieejami
        if (typeof config !== 'undefined' && !config.dataAvailableForCharts) { 
            const panelsToHide = ['.sankey-facts', '.balance-facts', '.summary-panel-facts'];

            panelsToHide.forEach(panelSelector => {
                const panel = document.querySelector(panelSelector);
                if (panel) {
                    const noDataEl = panel.querySelector('.no-data');
                    if (noDataEl) noDataEl.style.display = 'block';

                    const controls = panel.querySelector('.sankey-controls, .chart-container, .table-responsive-wrapper');
                    if (controls) controls.style.display = 'none';

                    const typeToggle = panel.querySelector('.sankey-type-toggle');
                    if (typeToggle) typeToggle.style.display = 'none';
                }
            });
        }

    } catch (error) {
        console.error("Kļūda ielādējot bibliotēkas vai inicializējot moduļus:", error);
    }
});