# projects/python_generator/config/table_definitions.py

# Šis fails definē datu avotus (tabulas), kā tos atrast un kā attēlot.

# No faila /config/table_definitions.php
TABLE_NAMES = [
    "akf_data", "arbitration_list", "arbitration_members", "area_of_activity",
    "areas_of_activity_of_associations_foundations", "balance_sheets",
    "cash_flow_statements", "equity_capitals", "farm_land", "financial_statements",
    "income_statements", "insolvency_legal_person_proceeding",
    "memorandum_date", "political_parties",
    "ppi_delegated_entities", "ppi_public_persons_institutions",
    "property_investment_appraisers_list", "register_name_history", "register",
    "religious_affiliations", "reorganizations",
    "securing_measures", "special_statuses",
    "suspensions_prohibitions", "liquidations",
    # === SĀKUMS: JAUNO FAILU PIEVIENOŠANA ===
    "pdb_nm_komersantu_samaksato_nodoklu_kopsumas_odata",
    "pdb_pvnmaksataji_odata",
    "reitings_uznemumi"
    # === BEIGAS: JAUNO FAILU PIEVIENOŠANA ===
]

# Definē, kurā kolonnā meklēt uzņēmuma reģistrācijas numuru katrā no tabulām.
# Noņemtas atsauces uz: beneficial_owners, members, officers, stockholders
SEARCH_COLUMNS_MAP_REG_NR = {
    "akf_data": ["legal_entity_registration_number"],
    "arbitration_list": ["legal_entity_registration_number"],
    "arbitration_members": ["at_legal_entity_registration_number"],
    "area_of_activity": ["legal_entity_registration_number"],
    "areas_of_activity_of_associations_foundations": ["regcode"],
    "equity_capitals": ["legal_entity_registration_number"],
    "farm_land": ["legal_entity_registration_number"],
    "financial_statements": ["legal_entity_registration_number"],
    "insolvency_legal_person_proceeding": ["debtor_registration_number"],
    "liquidations": ["legal_entity_registration_number"],
    "memorandum_date": ["legal_entity_registration_number"],
    "political_parties": ["legal_entity_registration_number"],
    "ppi_delegated_entities": ["delegatedEntityRegistrationNumber", "registrationNumber"],
    "ppi_public_persons_institutions": ["registrationNumber"],
    "property_investment_appraisers_list": ["legal_entity_registration_number"],
    "register_name_history": ["regcode"],
    "register": ["regcode"],
    "religious_affiliations": ["legal_entity_registration_number"],
    "securing_measures": ["legal_entity_registration_number"],
    "special_statuses": ["legal_entity_registration_number"],
    "suspensions_prohibitions": ["legal_entity_registration_number"],
    # === SĀKUMS: JAUNO FAILU PIEVIENOŠANA ===
    "pdb_nm_komersantu_samaksato_nodoklu_kopsumas_odata": ["Registracijas_kods"],
    "pdb_pvnmaksataji_odata": ["Numurs"],
    "reitings_uznemumi": ["Registracijas_kods"]
    # === BEIGAS: JAUNO FAILU PIEVIENOŠANA ===
}

# No faila /config/table_definitions.php ($GLOBALS['table_display_config'])
# Konfigurācija, kas nosaka, kā katru datu tabulu attēlot HTML lapā.
# Noņemti: officers, members, members_joint_owners, stockholders, stockholders_joint_owners, beneficial_owners
TABLE_DISPLAY_CONFIG = {
    'register': {'rank': 1, 'title': 'Uzņēmumu reģistrs', 'link': 'https://data.gov.lv/dati/dataset/uz', 'mysql_table_name': 'register'},
    'arbitration_list': {'rank': 2, 'title': 'Šķīrējtiesu saraksts', 'link': 'https://data.gov.lv/dati/dataset/arbitration_list', 'mysql_table_name': 'arbitration_list'},
    'farm_land': {'rank': 3, 'title': 'Zemnieku saimniecības zemes platība un tās atrašanās vieta', 'link': 'https://data.gov.lv/dati/dataset/farm-land', 'mysql_table_name': 'farm_land'},
    'political_parties': {'rank': 4, 'title': 'Politisko partiju un to apvienību saraksts', 'link': 'https://data.gov.lv/dati/dataset/political-parties', 'mysql_table_name': 'political_parties'},
    'ppi_public_persons_institutions': {'rank': 5, 'title': 'Publisko personu un iestāžu saraksts, Saeima un citi', 'link': 'https://data.gov.lv/dati/dataset/public-persons-institutions', 'mysql_table_name': 'ppi_public_persons_institutions'},
    'property_investment_appraisers_list': {'rank': 6, 'title': 'Mantiskā ieguldījuma vērtētāju saraksts', 'link': 'https://data.gov.lv/dati/dataset/property_investment_appraisers_list', 'mysql_table_name': 'property_investment_appraisers_list'},
    'religious_affiliations': {'rank': 7, 'title': 'Reliģisko organizāciju lietās reģistrētā konfesionālā piederības un darbības teritorija', 'link': 'https://data.gov.lv/dati/dataset/religious-affiliations', 'mysql_table_name': 'religious_affiliations'},
    'memorandum_date': {'rank': 8, 'title': 'Tiesību subjekta lietā reģistrēts lēmuma par dibināšanu pieņemšanas datums', 'link': 'https://data.gov.lv/dati/dataset/memorandum-date', 'mysql_table_name': 'memorandum_date'},
    'area_of_activity': {'rank': 9, 'title': 'Tiesību subjektu darbības mērķi un veidi', 'link': 'https://data.gov.lv/dati/dataset/area-of-activity', 'mysql_table_name': 'area_of_activity'},
    'akf_data': {'rank': 10, 'title': 'Paplašināta tiesību subjekta datu kopā saistībā ar ārvalstu komersantu filiāļu datiem', 'link': 'https://data.gov.lv/dati/dataset/akf-data', 'mysql_table_name': 'akf_data'},
    'areas_of_activity_of_associations_foundations': {'rank': 11, 'title': 'Biedrību un nodibinājumu darbības jomas', 'link': 'https://data.gov.lv/dati/dataset/biedribu-un-nodibinajumu-darbibas-jomas', 'mysql_table_name': 'areas_of_activity_of_associations_foundations'},
    'register_name_history': {'rank': 12, 'title': 'Tiesību subjektu vēsturiskie nosaukumi', 'link': 'https://data.gov.lv/dati/dataset/tiesibu-subjektu-vesturiskie-nosaukumi', 'mysql_table_name': 'register_name_history'},
    'ppi_delegated_entities': {'rank': 13, 'title': 'Publisko personu un iestāžu saraksts, deleģējusi valsts', 'link': 'https://data.gov.lv/dati/dataset/public-persons-institutions', 'mysql_table_name': 'ppi_delegated_entities'},
    'special_statuses': {'rank': 14, 'title': 'Tiesību subjektu nacionālās nozīmes statuss', 'link': 'https://data.gov.lv/dati/dataset/special-statuses', 'mysql_table_name': 'special_statuses'},
    'reorganizations': {'rank': 15, 'title': 'Tiesību subjektu reorganizācijas', 'link': 'https://data.gov.lv/dati/dataset/reorganizatons', 'mysql_table_name': 'reorganizations'},
    'suspensions_prohibitions': {'rank': 16, 'title': 'Tiesību subjektu lietās reģistrētie aktuālie darbības aizliegumi un darbības apturēšanas/atjaunošanas', 'link': 'https://data.gov.lv/dati/dataset/suspensions-prohibitions', 'mysql_table_name': 'suspensions_prohibitions'},
    'insolvency_legal_person_proceeding': {'rank': 17, 'title': 'Maksātnespējas procesi', 'link': 'https://data.gov.lv/dati/dataset/maksatnespejas-procesi', 'mysql_table_name': 'insolvency_legal_person_proceeding'},
    'liquidations': {'rank': 18, 'title': 'Ziņas par tiesību subjektu likvidācijas procesiem', 'link': 'https://data.gov.lv/dati/dataset/liquidations', 'mysql_table_name': 'liquidations'},
    'equity_capitals': {'rank': 19, 'title': 'Pamatkapitālu un ieguldījumu informācija', 'link': 'https://data.gov.lv/dati/dataset/equity-capitals', 'mysql_table_name': 'equity_capitals'},
    'financial_statements': {'rank': 20, 'title': 'Gada pārskatu pamatinformācija', 'link': 'https://data.gov.lv/dati/dataset/gada-parskatu-finansu-dati', 'mysql_table_name': 'financial_statements'},
    'income_statements': {'rank': 21, 'title': 'Peļņas vai zaudējumu aprēķini', 'link': 'https://data.gov.lv/dati/dataset/gada-parskatu-finansu-dati', 'mysql_table_name': 'income_statements'},
    'balance_sheets': {'rank': 22, 'title': 'Bilances', 'link': 'https://data.gov.lv/dati/dataset/gada-parskatu-finansu-dati', 'mysql_table_name': 'balance_sheets'},
    'cash_flow_statements': {'rank': 23, 'title': 'Naudas plūsmas pārskati', 'link': 'https://data.gov.lv/dati/dataset/gada-parskatu-finansu-dati', 'mysql_table_name': 'cash_flow_statements'},
    'securing_measures': {'rank': 24, 'title': 'Tiesību subjektu lietās reģistrētie nodrošinājumu līdzekļi', 'link': 'https://data.gov.lv/dati/dataset/securing-measures', 'mysql_table_name': 'securing_measures'},
    'arbitration_members': {'rank': 25, 'title': 'Šķīrējtiesu dibinātāji', 'link': 'https://data.gov.lv/dati/dataset/arbitration_members', 'mysql_table_name': 'arbitration_members'},
    # === SĀKUMS: JAUNO FAILU PIEVIENOŠANA ===
    'pdb_nm_komersantu_samaksato_nodoklu_kopsumas_odata': {'rank': 32, 'title': 'Samaksātie nodokļi 3 gados', 'link': 'https://data.gov.lv/dati/dataset/komersantu-ieprieksejos-tris-taksacijas-gados-samaksato-vid-administreto-nodoklu-kopsummas', 'mysql_table_name': 'pdb_nm_komersantu_samaksato_nodoklu_kopsumas_odata'},
    'pdb_pvnmaksataji_odata': {'rank': 33, 'title': 'PVN maksātājs', 'link': 'https://data.gov.lv/dati/dataset/pvn-maksataji', 'mysql_table_name': 'pdb_pvnmaksataji_odata'},
    'reitings_uznemumi': {'rank': 34, 'title': 'Nodokļu maksātāja reitings', 'link': 'https://data.gov.lv/dati/dataset/nodoklu-maksataju-reitings', 'mysql_table_name': 'reitings_uznemumi'},
    # === BEIGAS: JAUNO FAILU PIEVIENOŠANA ===
}