# kods/py/sitemap.py
from datetime import datetime
from .paths import OUT_DIR
# Pagaidām hardkodējam domēnu vai importējam no settings, ja tas ir pieejams
BASE_DOMAIN = "https://saraksts.lv" 

def generate(reg_nrs):
    print("   -> Ģenerē Sitemap un Robots.txt...")
    s_dir = OUT_DIR / "sitemaps"
    s_dir.mkdir(exist_ok=True)
    
    limit = 25000
    chunks = [reg_nrs[i:i + limit] for i in range(0, len(reg_nrs), limit)]
    files = []
    today = datetime.now().strftime('%Y-%m-%d')
    
    for i, chunk in enumerate(chunks):
        fname = f"sitemap-{i+1}.xml"
        lines = ['<?xml version="1.0" encoding="UTF-8"?>', '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">']
        for nr in chunk:
            lines.append(f'<url><loc>{BASE_DOMAIN}/{nr}</loc><lastmod>{today}</lastmod></url>')
        lines.append('</urlset>')
        with open(s_dir / fname, 'w', encoding='utf-8') as f: f.write("\n".join(lines))
        files.append(fname)
        
    idx_lines = ['<?xml version="1.0" encoding="UTF-8"?>', '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">']
    for f in files:
        idx_lines.append(f'<sitemap><loc>{BASE_DOMAIN}/sitemaps/{f}</loc><lastmod>{today}</lastmod></sitemap>')
    idx_lines.append('</sitemapindex>')
    
    with open(s_dir / "sitemap.xml", 'w', encoding='utf-8') as f: f.write("\n".join(idx_lines))
    
    with open(OUT_DIR / "robots.txt", 'w') as f:
        f.write("User-agent: *\nAllow: /\n")
        f.write(f"Sitemap: {BASE_DOMAIN}/sitemaps/sitemap.xml\n")