// projects/python_generator/templates/assets/js/modules/balance_chart.js

/**
 * Balance Sheet Chart Module
 * Atbild par bilances diagrammas zīmēšanu, izmantojot Chart.js.
 * Paļaujas uz globāli pieejamu Chart objektu.
 */
// projects/python_generator/templates/assets/js/modules/balance_chart.js

/**
 * Balance Sheet Chart Module
 * Atbild par bilances diagrammas zīmēšanu, izmantojot Chart.js.
 * Paļaujas uz globāli pieejamu Chart objektu.
 */

if (typeof Chart === 'undefined') {
    console.error("Chart.js nav ielādēts.");
}

let balanceChartInstance = null;
const balanceCanvasId = 'balanceChartCanvas';
const noDataMsgId = 'balance_no_data_msg';

export function drawBalanceChart(balanceData, currency, year, displayRoundingFactor = 1) {
    if (typeof Chart === 'undefined') {
        console.error("Chart.js nav pieejams, nevar zīmēt bilances diagrammu.");
        return;
    }
    
    const canvas = document.getElementById(balanceCanvasId);
    const noDataMsg = document.getElementById(noDataMsgId);

    if (!canvas || !noDataMsg) {
        console.error("Bilances diagrammas HTML elementi nav atrasti.");
        return;
    }

    if (balanceChartInstance) {
        balanceChartInstance.destroy();
        balanceChartInstance = null;
    }

    if (!balanceData) {
        noDataMsg.style.display = 'block';
        canvas.style.display = 'none';
        return;
    }

    noDataMsg.style.display = 'none';
    canvas.style.display = 'block';

    // Datu sagatavošana, piemērojot noapaļošanas koeficientu
    const currentAssets = (parseFloat(balanceData.total_current_assets) || 0) * displayRoundingFactor;
    const nonCurrentAssets = (parseFloat(balanceData.total_non_current_assets) || 0) * displayRoundingFactor;

    const currentLiabilities = (parseFloat(balanceData.current_liabilities) || 0) * displayRoundingFactor;
    const nonCurrentLiabilities = (parseFloat(balanceData.non_current_liabilities) || 0) * displayRoundingFactor;
    const equity = (parseFloat(balanceData.equity) || 0) * displayRoundingFactor;
    const provisions = (parseFloat(balanceData.provisions) || 0) * displayRoundingFactor;
    const equityAndProvisions = equity + provisions;

    const data = {
        labels: ['Aktīvi', 'Pasīvi'],
        datasets: [
            { label: 'Apgrozāmie Līdzekļi', data: [currentAssets, 0], backgroundColor: 'rgba(54, 162, 235, 0.7)', stack: 'AktīviStack' },
            { label: 'Ilgtermiņa Ieguldījumi', data: [nonCurrentAssets, 0], backgroundColor: 'rgba(75, 192, 192, 0.7)', stack: 'AktīviStack' },
            { label: 'Īstermiņa Saistības', data: [0, currentLiabilities], backgroundColor: 'rgba(255, 99, 132, 0.7)', stack: 'PasīviStack' },
            { label: 'Ilgtermiņa Saistības', data: [0, nonCurrentLiabilities], backgroundColor: 'rgba(255, 159, 64, 0.7)', stack: 'PasīviStack' },
            { label: 'Pašu Kapitāls & Uzkrājumi', data: [0, equityAndProvisions], backgroundColor: 'rgba(153, 102, 255, 0.7)', stack: 'PasīviStack' }
        ]
    };

    balanceChartInstance = new Chart(canvas, {
        type: 'bar',
        data: data,
        options: {
            indexAxis: 'y',
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: {
                    stacked: true,
                    beginAtZero: true,
                    title: { display: true, text: currency },
                    ticks: { callback: value => value.toLocaleString('lv-LV') }
                },
                y: { stacked: true }
            },
            plugins: {
                title: { display: true, text: `Bilances Struktūra ${year}`, font: { size: 16 } },
                tooltip: { callbacks: { label: ctx => `${ctx.dataset.label || ''}: ${ctx.parsed.x.toLocaleString('lv-LV')}` } }
            }
        }
    });
}