<?php
// Saglabājam jūsu oriģinālo PHP loģiku aktīvās lapas noteikšanai
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!DOCTYPE html>
<style>
    /* --- GALVENES PAMATA STILS --- */
    .main-header {
        background-color: #140a3f; /* Tumši zils fons */
        color: white;
        padding: 15px 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        
        /* KRITISKIE LABOJUMI NOBĪDEI: */
        /* Izmantojam !important, lai 'nozare.php' stili nevarētu šo pārrakstīt */
        position: fixed !important; 
        top: 0 !important;
        left: 0 !important;
        width: 100% !important;
        z-index: 99999 !important; /* Lai vienmēr būtu virs visa cita */
        
        /* Šis novērš problēmu, ja 'nozare.php' body elementam ir transformācija/animācija */
        transform: none !important; 
        
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        transition: padding 0.3s ease-in-out; /* Animējam tikai padding */
        box-sizing: border-box;
    }

    /* Logo stils */
    .logo-wrapper .logo {
        color: white;
        text-decoration: none;
        font-size: 24px;
        font-weight: bold;
        transition: font-size 0.3s ease-in-out;
        display: block; /* Drošībai */
    }

    /* --- HAMBURGERA POGA (Reset + Stils) --- */
    .menu-toggle {
        display: none; /* Uz datora paslēpts */
        
        /* NOŅEMAM JEBKĀDUS VECOS STILUS */
        background: none !important;
        border: none !important;
        box-shadow: none !important;
        outline: none !important;
        margin: 0 !important;
        
        /* JAUNAIS STILS */
        color: white;
        font-size: 30px;
        cursor: pointer;
        padding: 0 10px;
        line-height: 1;
    }

    /* --- NAVIGĀCIJA (Dators) --- */
    .main-nav ul {
        margin: 0;
        padding: 0;
        list-style: none;
        display: flex;
        gap: 20px;
    }

    .main-nav a {
        color: white;
        text-decoration: none;
        font-size: 16px;
        padding: 5px 10px;
        transition: color 0.3s;
        font-weight: 500;
    }

    .main-nav a:hover,
    .main-nav a.active {
        color: #4CAF50; /* Zaļa aktīvā krāsa */
        font-weight: bold;
    }

    /* --- MOBILAIS SKATS (Līdz 768px) --- */
    @media (max-width: 768px) {
        .menu-toggle {
            display: block; /* Parādām pogu */
        }

        .main-nav {
            display: none; /* Pēc noklusējuma slēpts */
            position: absolute;
            /* Piesaistām tieši zem header (kas var mainīties), bet sākam ar standarta */
            top: 100%; 
            left: 0;
            width: 100%;
            background-color: #140a3f;
            flex-direction: column;
            padding-bottom: 20px;
            box-shadow: 0 5px 10px rgba(0,0,0,0.3);
            border-top: 1px solid rgba(255,255,255,0.1);
        }

        /* Šo klasi pievieno JavaScript */
        .main-nav.active {
            display: flex;
        }

        .main-nav ul {
            flex-direction: column;
            width: 100%;
            text-align: center;
            gap: 0;
        }

        .main-nav a {
            display: block;
            padding: 15px;
            border-bottom: 1px solid rgba(255,255,255,0.05);
            font-size: 18px;
        }
    }

    /* Lai saturs nepazustu zem fiksētā header */
    /* !important nodrošina, ka šis strādās arī nozare.php */
    body {
        padding-top: 80px !important; 
    }
</style>

<header class="main-header" id="main-header">
    <div class="logo-wrapper">
        <a href="index.php" class="logo" id="site-logo">Saraksts.lv</a>
    </div>

    <button class="menu-toggle" id="menu-toggle" aria-label="Atvērt izvēlni">
        &#9776;
    </button>

    <nav class="main-nav" id="main-nav">
        <ul>
            <li><a href="index.php" class="<?= ($current_page == 'index.php' || $current_page == '') ? 'active' : '' ?>">Reģistrs</a></li>
            <li><a href="nozare.php" class="<?= $current_page == 'nozare.php' ? 'active' : '' ?>">Nozare</a></li>
            <li><a href="struktura.php" class="<?= $current_page == 'struktura.php' ? 'active' : '' ?>">Struktūra</a></li>
            <li><a href="iespeja.php" class="<?= $current_page == 'iespeja.php' ? 'active' : '' ?>">Iespēja</a></li>
            <li><a href="pensionars.php" class="<?= $current_page == 'pensionars.php' ? 'active' : '' ?>">Pensionārs</a></li>
            <li><a href="lejupielade.php" class="<?= $current_page == 'lejupielade.php' ? 'active' : '' ?>">Lejupielāde</a></li>
        </ul>
    </nav>
</header>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const menuToggle = document.getElementById('menu-toggle');
    const mainNav = document.getElementById('main-nav');
    const mainHeader = document.getElementById('main-header');
    const siteLogo = document.getElementById('site-logo');

    // 1. HAMBURGERA KLIKŠĶIS
    if (menuToggle && mainNav) {
        menuToggle.addEventListener('click', function(e) {
            e.stopPropagation(); // Novērš konfliktus ar citiem klikšķiem
            mainNav.classList.toggle('active');
        });
        
        // Aizveram, ja klikšķina ārpusē
        document.addEventListener('click', function(e) {
            if (!mainHeader.contains(e.target) && mainNav.classList.contains('active')) {
                mainNav.classList.remove('active');
            }
        });
    }

    // 2. SKROLLĒŠANAS SAMAZINĀŠANA
    window.addEventListener('scroll', function() {
        let scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        
        if (scrollTop > 50) {
            mainHeader.style.padding = '5px 20px';
            if(siteLogo) siteLogo.style.fontSize = '20px';
        } else {
            mainHeader.style.padding = '15px 20px';
            if(siteLogo) siteLogo.style.fontSize = '24px';
        }
    });
});
</script>